# 🔧 cPanel/Shared Hosting Import Guide

## 📌 You're on Shared Hosting!

Since you're getting the "Access denied" error, you're on **shared hosting** (cPanel, Plesk, or similar). The database import process is slightly different.

---

## ✅ Step-by-Step Instructions

### Step 1: Create Database via cPanel

1. **Login to cPanel**
2. **Find "MySQL® Databases"** (or "MySQL Databases")
3. **Create New Database**:
   - Enter database name: `faceml` (or `faceml_db`)
   - Click "Create Database"
   - Your actual database name will be: `cpses_roi5cr9dl1_faceml` (or similar with your prefix)
   - **⚠️ IMPORTANT: Note down the FULL database name!**

4. **Create Database User** (if not already created):
   - Username: `faceml_user` (or any name)
   - Password: Generate a strong password
   - Click "Create User"
   - Actual username will be: `cpses_roi5cr9dl1_faceml_user` (with prefix)
   - **⚠️ Note down the FULL username and password!**

5. **Add User to Database**:
   - Select the user you created
   - Select the database you created
   - Grant "ALL PRIVILEGES"
   - Click "Make Changes"

### Step 2: Import Database via phpMyAdmin

1. **Go to phpMyAdmin** (usually found in cPanel)
2. **Select your database** from the left sidebar
   - Look for: `cpses_roi5cr9dl1_faceml` (or whatever name you got)
3. **Click "Import" tab**
4. **Choose file**: Select `faceml_database_cpanel.sql` ⭐ (Use the cPanel version!)
5. **Scroll down and click "Go"**
6. **Wait for success message** ✅

### Step 3: Verify Import

In phpMyAdmin, you should now see 6 tables:
- ✅ attendance
- ✅ branches  
- ✅ shops
- ✅ staff
- ✅ users
- ✅ work_sessions

---

## 🔧 Configure Backend for cPanel Database

### Update .env file

Create/edit your `.env` file with your cPanel database details:

```env
NODE_ENV=production
PORT=3000

# Use your FULL cPanel database details (with prefix)
DB_HOST=localhost
DB_USER=cpses_roi5cr9dl1_faceml_user
DB_PASSWORD=your_database_password_here
DB_NAME=cpses_roi5cr9dl1_faceml
DB_PORT=3306

JWT_SECRET=generate_32_char_random_string
SUPER_ADMIN_EMAIL=admin@faceml.com
SUPER_ADMIN_PASSWORD=Admin@123
```

**Important**: Replace with YOUR actual values:
- `DB_USER`: Your full database username (with cPanel prefix)
- `DB_PASSWORD`: The password you set for the database user
- `DB_NAME`: Your full database name (with cPanel prefix)

### Generate JWT Secret

```bash
node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"
```

Copy the output and use it as your `JWT_SECRET`.

---

## 🚀 Initialize Backend

### 1. Install Dependencies

```bash
cd /path/to/your/backend
npm install
```

### 2. Initialize Super Admin Password

```bash
node scripts/initDatabase.js
```

This will:
- Connect to your cPanel database
- Create proper password hash for admin user
- Display login credentials

### 3. Start Server

```bash
# Test mode
node server.js

# Production mode (recommended)
npm install -g pm2
pm2 start server.js --name faceml-backend
pm2 save
```

### 4. Test Your Backend

```bash
# Health check
curl http://localhost:3000/health

# Or visit in browser:
# http://your-domain.com:3000/health
```

---

## 🔍 Finding Your Database Details

If you don't know your database details:

### Method 1: Check cPanel
1. Go to cPanel → MySQL® Databases
2. Scroll to "Current Databases" section
3. Note the full database name (with prefix)
4. Scroll to "Current Users" section  
5. Note the full username (with prefix)

### Method 2: Check Existing Config
If you have other applications, check their config files for the database prefix pattern.

---

## 🎯 Common cPanel Database Patterns

Your database details will look like:

| Pattern | Example |
|---------|---------|
| Database Name | `cpses_abc123_faceml` |
| Username | `cpses_abc123_user` |
| Host | `localhost` |
| Port | `3306` |
| Prefix | `cpses_abc123_` |

The prefix (`cpses_abc123_`) is automatically added by cPanel and **cannot be removed**.

---

## ✅ Verification Checklist

- [ ] Database created via cPanel
- [ ] Database user created and assigned to database
- [ ] Noted down FULL database name (with prefix)
- [ ] Noted down FULL username (with prefix)
- [ ] Noted down password
- [ ] Imported `faceml_database_cpanel.sql` via phpMyAdmin
- [ ] 6 tables visible in phpMyAdmin
- [ ] Created `.env` file with correct cPanel database details
- [ ] Generated JWT_SECRET
- [ ] Ran `npm install`
- [ ] Ran `node scripts/initDatabase.js`
- [ ] Server starts without errors
- [ ] Health check returns OK

---

## 🐛 Troubleshooting

### "Access Denied" Error
- Make sure you're using the FULL database name (with prefix)
- Make sure you're using the FULL username (with prefix)
- Verify password is correct
- Check user has "ALL PRIVILEGES" on the database

### "Can't Connect to Database"
- Check DB_HOST is `localhost` (not an IP)
- Check DB_PORT is `3306`
- Test connection from command line:
  ```bash
  mysql -u your_full_username -p -h localhost your_full_database
  ```

### "Table Already Exists"
If you get this error:
1. Go to phpMyAdmin
2. Select your database
3. Click "Drop" to delete old tables
4. Try import again

### Can't Run Node.js
Some shared hosting doesn't support Node.js. Check with your host:
- Do they support Node.js?
- What version?
- How to run Node.js apps?

Consider upgrading to VPS if needed.

---

## 📊 Example Working Configuration

Here's a complete example with fictional but realistic values:

**cPanel Database Setup:**
```
Database Name: cpses_roi5cr9dl1_faceml
Database User: cpses_roi5cr9dl1_fmuser
Database Pass: xK9m#pL2$vN8qR4t
```

**.env File:**
```env
NODE_ENV=production
PORT=3000

DB_HOST=localhost
DB_USER=cpses_roi5cr9dl1_fmuser
DB_PASSWORD=xK9m#pL2$vN8qR4t
DB_NAME=cpses_roi5cr9dl1_faceml
DB_PORT=3306

JWT_SECRET=a7f8d9e6c5b4a3927f8e9d0c1b2a3f4e5d6c7b8a9f0e1d2c3b4a5f6e7d8c9b0
SUPER_ADMIN_EMAIL=admin@faceml.com
SUPER_ADMIN_PASSWORD=Admin@123
```

---

## 🎉 Success!

Once everything is set up:

**Default Login:**
- Email: `admin@faceml.com`
- Password: `Admin@123`

**⚠️ IMPORTANT:** Change this password immediately after first login!

**Your API will be available at:**
- `http://your-domain.com:3000/api`
- Or if using Nginx proxy: `http://your-domain.com/api`

---

## 📞 Still Having Issues?

Common issues on shared hosting:

1. **No Node.js support**: Upgrade to VPS hosting
2. **Port restrictions**: Use Nginx/Apache proxy
3. **Memory limits**: Upgrade hosting plan
4. **Can't install npm packages**: Contact hosting support

**Recommended hosting for Node.js:**
- DigitalOcean Droplet ($6/month)
- AWS Lightsail ($5/month)
- Linode ($5/month)
- Vultr ($5/month)

These give you full control and no database name prefixes!

---

Good luck with your deployment! 🚀

