# Database Dump Guide

This guide explains how to dump your current database to import on your server.

## Quick Start

### Option 1: Using Shell Script (Recommended - Fastest)

```bash
cd backend
./dump_database.sh
```

This will create a file like: `faceml_database_dump_20250101_120000.sql`

### Option 2: Using Node.js Script (Works without mysqldump)

```bash
cd backend
node scripts/dumpDatabaseWithData.js
```

For cPanel/shared hosting:
```bash
node scripts/dumpDatabaseWithData.js cpanel
```

For full dump with CREATE DATABASE:
```bash
node scripts/dumpDatabaseWithData.js full
```

## Prerequisites

### For Shell Script (Option 1):
- MySQL client tools installed
  - macOS: `brew install mysql-client`
  - Ubuntu: `sudo apt-get install mysql-client`
  - Windows: Install MySQL Workbench or MySQL Command Line Client

### For Node.js Script (Option 2):
- Node.js and npm installed
- All dependencies installed: `npm install`

## Database Configuration

Both scripts will read from `.env` file if it exists. Make sure your `.env` file contains:

```env
DB_HOST=localhost
DB_USER=root
DB_PASSWORD=your_password
DB_NAME=faceml_db
DB_PORT=3306
```

If you don't have a `.env` file, the scripts will use default values:
- Host: localhost
- User: root
- Password: (empty)
- Database: faceml_db
- Port: 3306

## Importing on Your Server

### Method 1: Using MySQL Command Line

```bash
mysql -u YOUR_USER -p YOUR_DATABASE < faceml_database_dump_YYYYMMDD_HHMMSS.sql
```

### Method 2: Using phpMyAdmin (cPanel)

1. Log in to cPanel
2. Open phpMyAdmin
3. Create a new database (if needed)
4. Select your database
5. Click the "Import" tab
6. Choose your SQL file
7. Click "Go"

### Method 3: Using MySQL Workbench

1. Connect to your server
2. Go to Server > Data Import
3. Select "Import from Self-Contained File"
4. Choose your SQL file
5. Select target database
6. Click "Start Import"

## What's Included in the Dump

- ✅ Complete table structures
- ✅ All data (INSERT statements)
- ✅ Indexes and foreign keys
- ✅ Proper dependency ordering

## Troubleshooting

### Error: "mysqldump command not found"
- Install MySQL client tools (see Prerequisites)
- Or use the Node.js script instead

### Error: "Access denied"
- Check your database credentials in `.env`
- Verify database user has SELECT privileges

### Error: "Database connection failed"
- Verify database is running
- Check host, port, and credentials
- Test connection: `mysql -u USER -p -h HOST`

## File Locations

- Shell script: `backend/dump_database.sh`
- Node.js script: `backend/scripts/dumpDatabaseWithData.js`
- Output files: `backend/faceml_database_*.sql`





















