# ✅ Deployment Checklist

Use this checklist to ensure smooth deployment of your FaceML backend.

---

## 📋 Pre-Deployment

- [ ] Have access to your server (SSH)
- [ ] MySQL/MariaDB installed on server
- [ ] Node.js 16+ installed on server
- [ ] phpMyAdmin access (optional but helpful)
- [ ] Downloaded `faceml_database.sql` file
- [ ] Have your MySQL credentials ready

---

## 🗄️ Database Setup (5 minutes)

### Method 1: phpMyAdmin (Recommended)
- [ ] Login to phpMyAdmin
- [ ] Click "Import" tab
- [ ] Choose `faceml_database.sql` file
- [ ] Click "Go" to import
- [ ] Verify "faceml_db" database is created
- [ ] Verify 6 tables are created (users, shops, branches, staff, attendance, work_sessions)

### Method 2: MySQL Command Line
- [ ] Run: `mysql -u root -p < faceml_database.sql`
- [ ] Verify: `mysql -u root -p -e "USE faceml_db; SHOW TABLES;"`

---

## 📁 Backend Setup (10 minutes)

- [ ] Upload/clone backend folder to server
- [ ] Navigate to backend directory: `cd /path/to/backend`
- [ ] Create `.env` file with these values:
  ```
  NODE_ENV=production
  PORT=3000
  DB_HOST=localhost
  DB_USER=your_mysql_user
  DB_PASSWORD=your_mysql_password
  DB_NAME=faceml_db
  DB_PORT=3306
  JWT_SECRET=generate_32_char_random_string
  SUPER_ADMIN_EMAIL=admin@faceml.com
  SUPER_ADMIN_PASSWORD=Admin@123
  ```
- [ ] Generate JWT_SECRET: `node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"`
- [ ] Install dependencies: `npm install`
- [ ] Initialize super admin: `node scripts/initDatabase.js`
- [ ] Test locally: `node server.js`
- [ ] Visit: `http://localhost:3000/health` (should return OK)

---

## 🚀 Production Setup (15 minutes)

- [ ] Install PM2: `npm install -g pm2`
- [ ] Start with PM2: `pm2 start server.js --name faceml-backend`
- [ ] Setup auto-start: `pm2 startup` then `pm2 save`
- [ ] Test: `curl http://localhost:3000/health`

### Optional but Recommended: Nginx Setup
- [ ] Install Nginx: `sudo apt install nginx`
- [ ] Create config: `sudo nano /etc/nginx/sites-available/faceml-api`
- [ ] Enable site: `sudo ln -s /etc/nginx/sites-available/faceml-api /etc/nginx/sites-enabled/`
- [ ] Test config: `sudo nginx -t`
- [ ] Restart Nginx: `sudo systemctl restart nginx`
- [ ] Test: `curl http://your-domain/health`

### Optional: SSL Certificate
- [ ] Install Certbot: `sudo apt install certbot python3-certbot-nginx`
- [ ] Get certificate: `sudo certbot --nginx -d api.yourdomain.com`
- [ ] Test HTTPS: `curl https://api.yourdomain.com/health`

---

## 🧪 Testing (5 minutes)

- [ ] **Health Check**:
  ```bash
  curl http://your-server/health
  ```
  Should return: `{"status":"OK",...}`

- [ ] **Login Test**:
  ```bash
  curl -X POST http://your-server/api/auth/login \
    -H "Content-Type: application/json" \
    -d '{"email":"admin@faceml.com","password":"Admin@123"}'
  ```
  Should return JWT token

- [ ] **PM2 Status**:
  ```bash
  pm2 status
  ```
  Should show "faceml-backend" as "online"

---

## 📱 Flutter App Update

- [ ] Update API URL in `lib/services/api_service.dart`:
  ```dart
  static const String baseUrl = 'https://api.yourdomain.com/api';
  ```
- [ ] Test login from Flutter app
- [ ] Test face registration
- [ ] Test attendance marking

---

## 🔒 Security Hardening

- [ ] Change super admin password (login and update from app)
- [ ] Verify JWT_SECRET is strong (32+ characters)
- [ ] MySQL only listens on localhost
- [ ] Firewall configured (allow only 22, 80, 443)
- [ ] SSL/HTTPS enabled
- [ ] Database backups configured

---

## 📊 Monitoring Setup

- [ ] PM2 monitoring: `pm2 monit`
- [ ] View logs: `pm2 logs faceml-backend`
- [ ] Setup log rotation: `pm2 install pm2-logrotate`
- [ ] Setup database backups (see DEPLOYMENT_GUIDE.md)

---

## 🎉 Post-Deployment

- [ ] Documented your server credentials (securely!)
- [ ] Documented your API URL
- [ ] Created database backup
- [ ] Tested all API endpoints
- [ ] Tested Flutter app with production backend
- [ ] Changed default admin password

---

## 📞 Common Issues

### Can't connect to database
```bash
# Check MySQL is running
sudo systemctl status mysql

# Check .env credentials
cat .env | grep DB_
```

### Port 3000 already in use
```bash
# Find what's using it
sudo lsof -i :3000

# Change port in .env
PORT=3001
```

### PM2 not starting
```bash
# Check logs
pm2 logs faceml-backend --lines 50

# Restart
pm2 restart faceml-backend
```

---

## 🔄 Maintenance Commands

```bash
# View backend status
pm2 status

# View logs
pm2 logs faceml-backend

# Restart backend
pm2 restart faceml-backend

# Stop backend
pm2 stop faceml-backend

# Database backup
mysqldump -u root -p faceml_db > backup_$(date +%Y%m%d).sql
```

---

## ✅ Done!

Your backend is deployed and ready to use! 

**Your API endpoints:**
- Base URL: `http://your-domain/api` (or `https://` if SSL enabled)
- Health: `http://your-domain/health`

**Default credentials:**
- Email: admin@faceml.com
- Password: Admin@123 (CHANGE THIS!)

---

For detailed instructions, see: [DEPLOYMENT_GUIDE.md](./DEPLOYMENT_GUIDE.md)

