# Fix for Encrypted Data Display

If you are seeing encrypted data (random characters) in your app instead of real names, it means the backend server hasn't picked up the new encryption key from the `.env` file yet.

**PM2 does not reload environment variables on a simple restart.** You must reload or delete/start the process.

## Solution

Run these commands on your server:

```bash
cd /home/rootclockin/public_html  # or your backend directory
pm2 reload all --update-env
```

**OR** if that doesn't work:

```bash
pm2 delete all
pm2 start server.js --name "server"
# Add your other processes if any
```

## Verification

1.  Check the logs to ensure the key is loaded (I added debug logs):
    ```bash
    pm2 logs
    ```
    You should NOT see "CRITICAL: ENCRYPTION_KEY is missing".

2.  Open your app and refresh. The names should now appear correctly.
