# ⚡ ONE COMMAND FIX

## Your Problem:
```
{"error":"Invalid credentials"}
```

## The Solution:
```bash
node scripts/hashPasswords.js
```

---

## 🚀 Full Steps (Copy-Paste)

### On Your Server:

```bash
# 1. Go to backend folder
cd /root/public_html/backend

# 2. Install dependencies (if not already done)
npm install

# 3. Run the password hash script
node scripts/hashPasswords.js
```

### Expected Output:
```
✓ Super Admin password updated
✓ Shop Admin password updated
✅ All tests passed! You can now login via API.
```

---

## ✅ Then Test Login:

```bash
curl --location 'http://180.92.197.145:3200/api/auth/login' \
--header 'Content-Type: application/json' \
--data-raw '{
    "email": "admin@faceml.com",
    "password": "Admin@123"
}'
```

**Should return:** Token instead of error ✓

---

## 🔍 Why This Fixes It:

The SQL file has **fake placeholder** password hashes like:
```
$2a$10$YourHashedPasswordHere
```

This script generates **REAL bcrypt hashes** for your passwords.

---

## ⚠️ If Script Fails:

### Error: "Cannot find module"
```bash
npm install bcryptjs mysql2 dotenv
```

### Error: "Database connection failed"
Check your `.env` file has correct:
- DB_HOST
- DB_USER
- DB_PASSWORD
- DB_NAME

### Error: Missing JWT_SECRET
Add to `.env`:
```bash
# Generate one:
node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"

# Add to .env:
JWT_SECRET=paste_generated_value_here
```

---

## 📁 Files You Need on Server:

```
backend/
├── .env (with DB credentials)
├── package.json
├── node_modules/ (after npm install)
└── scripts/
    └── hashPasswords.js ← THIS FILE!
```

---

## 🎯 JUST RUN THIS:

```bash
cd /root/public_html/backend && node scripts/hashPasswords.js
```

**Done!** ✅

