# ⚡ Quick Import Guide for cPanel (5 Minutes)

## 🎯 Use This File: `faceml_database_cpanel_NEW.sql`

---

## ⏱️ 5-Step Quick Import

### Step 1: Create Database (2 min)
1. Login to **cPanel**
2. Click **MySQL Databases**
3. Create database name: `faceml`
4. Note full name: `cpses_12345_faceml` (example)
5. Create user → Grant **ALL PRIVILEGES**

### Step 2: Import SQL (1 min)
1. Open **phpMyAdmin**
2. Select your database
3. Click **Import** tab
4. Choose: `faceml_database_cpanel_NEW.sql`
5. Click **Go**
6. Wait for ✓ Success

### Step 3: Create .env File (1 min)
Create `.env` in backend folder:

```env
DB_HOST=localhost
DB_USER=cpses_12345_user
DB_PASSWORD=your_password_here
DB_NAME=cpses_12345_faceml
DB_PORT=3306
PORT=3000
JWT_SECRET=your_random_32_char_secret_generate_with_command_below
SUPER_ADMIN_EMAIL=admin@faceml.com
SUPER_ADMIN_PASSWORD=Admin@123
```

Generate JWT secret:
```bash
node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"
```

### Step 4: Install & Initialize (1 min)
```bash
cd backend
npm install
node scripts/initDatabase.js
```

This hashes the passwords securely.

### Step 5: Start Server (<1 min)
```bash
# Test mode
node server.js

# Production mode (recommended)
pm2 start server.js --name faceml
pm2 save
```

---

## ✅ Test It Works

**Quick API Test:**
```bash
curl -X POST http://your-domain.com:3000/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{"email":"shop@gmail.com","password":"123456"}'
```

**Expected:** JSON response with `token` field ✓

**In Flutter App:**
- Update API URL
- Login: `shop@gmail.com` / `123456`

---

## 📊 What You Get

✅ **2 Admin Accounts:**
- Super Admin: `admin@faceml.com` / `Admin@123`
- Shop Admin: `shop@gmail.com` / `123456`

✅ **Demo Data:**
- 1 Shop (Demo Shop)
- 1 Branch (Main Branch)
- 5 Staff members with hourly rates ($10-15/hr)

✅ **6 Database Tables:**
- users, shops, branches, staff, attendance, work_sessions

---

## 🔒 Security (DO IMMEDIATELY!)

After import:
- [ ] Change super admin password
- [ ] Change shop admin password
- [ ] Update JWT_SECRET with strong random value
- [ ] Enable SSL/HTTPS on your domain
- [ ] Never commit .env to git

---

## 🐛 Troubleshooting

**"Database connection failed"**
→ Check credentials in .env match cPanel MySQL user/database

**"Access denied"**
→ Verify MySQL user has ALL PRIVILEGES on the database

**"Invalid credentials" on login**
→ Run `node scripts/initDatabase.js` again

**"Cannot find module"**
→ Run `npm install` in backend folder

**"Port already in use"**
→ Change PORT in .env to 3001 or other available port

---

## 📞 Need More Help?

See detailed guide: `IMPORT_GUIDE_NEW.md`

---

**Last Updated:** October 30, 2025  
**Estimated Time:** 5 minutes  
**Difficulty:** Easy ⭐

