# 🚀 Quick Database Import Guide

## For phpMyAdmin (Easiest Method)

### Step 1: Login to phpMyAdmin
Open your browser and go to your phpMyAdmin URL (usually `http://your-server-ip/phpmyadmin`)

### Step 2: Import Database
1. Click on "**Import**" tab in the top menu
2. Click "**Choose File**" button
3. Select the file: `faceml_database.sql`
4. Scroll down and click "**Go**" button
5. Wait for import to complete (should take a few seconds)

### Step 3: Verify Import
1. Click on the "**faceml_db**" database in the left sidebar
2. You should see 6 tables:
   - ✅ attendance
   - ✅ branches
   - ✅ shops
   - ✅ staff
   - ✅ users
   - ✅ work_sessions

### Step 4: Setup Backend
1. Upload the entire `backend` folder to your server
2. Copy `.env.example` to `.env`:
   ```bash
   cp .env.example .env
   ```
3. Edit `.env` and update database credentials:
   ```bash
   nano .env
   ```
4. Install dependencies:
   ```bash
   npm install
   ```
5. Initialize super admin password:
   ```bash
   node scripts/initDatabase.js
   ```
6. Start the server:
   ```bash
   node server.js
   ```

### Step 5: Test
Open browser or use curl:
```bash
curl http://localhost:3000/health
```

Should return:
```json
{"status":"OK","timestamp":"...","environment":"production"}
```

---

## For MySQL Command Line

```bash
# Login to MySQL
mysql -u root -p

# Import the database file
mysql -u root -p < faceml_database.sql

# Verify
mysql -u root -p -e "USE faceml_db; SHOW TABLES;"
```

---

## Default Login Credentials

After running `node scripts/initDatabase.js`:

- **Email**: admin@faceml.com
- **Password**: Admin@123

⚠️ **IMPORTANT**: Change this password immediately after first login!

---

## Need More Help?

See full deployment guide: [DEPLOYMENT_GUIDE.md](./DEPLOYMENT_GUIDE.md)

---

## Files You Need to Upload

```
backend/
├── faceml_database.sql          ← Import this first
├── .env.example                 ← Copy to .env and configure
├── package.json
├── server.js
├── config/
│   └── database.js
├── controllers/
├── middleware/
├── routes/
└── scripts/
    └── initDatabase.js          ← Run this after import
```

---

## Quick Commands

```bash
# Install dependencies
npm install

# Initialize database with super admin
node scripts/initDatabase.js

# Start server (development)
node server.js

# Start server (production with PM2)
pm2 start server.js --name faceml-backend

# View logs
pm2 logs faceml-backend

# Restart server
pm2 restart faceml-backend
```

That's it! Your backend should be running. 🎉

