# 🚀 Setup Guide for rootclockin Server

## ✅ Your Database Info

- **Database**: `rootclockin_db`
- **User**: `rootclockin_user`
- **Password**: `#1_Oc&FelV$B.c9I`
- **Host**: `localhost`

---

## 📋 Step-by-Step Setup

### Step 1: Import Database (phpMyAdmin)

1. **Open phpMyAdmin**
2. **Find and CLICK** on `rootclockin_db` in the left sidebar
3. **Click "Import" tab**
4. **Choose file**: `faceml_database_cpanel.sql`
5. **Click "Go"**
6. ✅ **Verify**: You should see 6 tables:
   - users
   - shops
   - branches
   - staff
   - attendance
   - work_sessions

---

### Step 2: Upload Backend Files

Upload your entire `backend` folder to your server using:
- **cPanel File Manager**, OR
- **FTP client** (FileZilla, etc.), OR
- **SSH/Terminal**

Example location: `/home/rootclockin/public_html/backend/`

---

### Step 3: Create .env File

**Using cPanel File Manager:**

1. Go to **cPanel > File Manager**
2. Navigate to your `backend` folder
3. Click **"+ File"** button
4. Name it: `.env`
5. Right-click the `.env` file and choose **"Edit"**
6. Copy and paste this content:

```env
NODE_ENV=production
PORT=3000

DB_HOST=localhost
DB_USER=rootclockin_user
DB_PASSWORD=#1_Oc&FelV$B.c9I
DB_NAME=rootclockin_db
DB_PORT=3306

JWT_SECRET=YOUR_GENERATED_SECRET_HERE

SUPER_ADMIN_EMAIL=admin@faceml.com
SUPER_ADMIN_PASSWORD=Admin@123
```

7. **Save and Close**

---

### Step 4: Generate JWT Secret

**Using Terminal/SSH Access:**

```bash
cd /home/rootclockin/public_html/backend
node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"
```

This will output something like:
```
a7f8d9e6c5b4a3927f8e9d0c1b2a3f4e5d6c7b8a9f0e1d2c3b4a5f6e7d8c9b0
```

**Copy this output** and edit your `.env` file:

```env
JWT_SECRET=a7f8d9e6c5b4a3927f8e9d0c1b2a3f4e5d6c7b8a9f0e1d2c3b4a5f6e7d8c9b0
```

**Alternative** (if you don't have SSH access):
Use an online random string generator:
- Go to: https://www.random.org/strings/
- Generate a 64-character alphanumeric string
- Use that as your JWT_SECRET

---

### Step 5: Install Dependencies

```bash
cd /home/rootclockin/public_html/backend
npm install
```

This will install all required packages (express, mysql2, bcryptjs, etc.)

---

### Step 6: Initialize Super Admin

```bash
cd /home/rootclockin/public_html/backend
node scripts/initDatabase.js
```

**Expected output:**
```
🔄 Connecting to MySQL server...
✓ Connected to MySQL server
✓ Database schema created successfully
🔄 Creating default superadmin...
✓ Default superadmin created/updated

✅ Database initialization completed successfully!

Default Login Credentials:
Email: admin@faceml.com
Password: Admin@123

⚠️  Please change the default password after first login!
```

---

### Step 7: Start Backend Server

**Option A: Direct Node (for testing)**
```bash
node server.js
```

**Option B: PM2 (recommended for production)**
```bash
# Install PM2
npm install -g pm2

# Start server
pm2 start server.js --name faceml-backend

# Setup auto-restart on server reboot
pm2 startup
pm2 save

# View logs
pm2 logs faceml-backend
```

---

### Step 8: Test Your Backend

**Health Check:**
```bash
curl http://localhost:3000/health
```

**Or visit in browser:**
```
http://your-domain.com:3000/health
```

**Expected response:**
```json
{
  "status": "OK",
  "timestamp": "2025-10-24T...",
  "environment": "production"
}
```

**Test Login:**
```bash
curl -X POST http://localhost:3000/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{
    "email": "admin@faceml.com",
    "password": "Admin@123"
  }'
```

Should return a JWT token.

---

### Step 9: Configure Domain/URL (Optional)

If you want to access your API via domain (without :3000 port), you need to:

1. **Setup Nginx or Apache reverse proxy**
2. **Or use cPanel's Node.js App interface** (if available)

Ask your hosting provider about Node.js app deployment.

---

### Step 10: Update Flutter App

In your Flutter app, update the API URL:

**File**: `lib/services/api_service.dart`

```dart
class ApiService {
  // Update this URL
  static const String baseUrl = 'http://your-domain.com:3000/api';
  
  // Or if using proxy:
  // static const String baseUrl = 'https://api.your-domain.com/api';
  
  // Rest of your code...
}
```

Then rebuild your Flutter app:
```bash
flutter clean
flutter pub get
flutter build apk
```

---

## ✅ Verification Checklist

- [ ] Database `rootclockin_db` visible in phpMyAdmin
- [ ] 6 tables imported successfully
- [ ] Backend folder uploaded to server
- [ ] `.env` file created with correct credentials
- [ ] JWT_SECRET generated and added to `.env`
- [ ] `npm install` completed successfully
- [ ] `node scripts/initDatabase.js` ran without errors
- [ ] Server starts without errors (`node server.js`)
- [ ] Health check returns `{"status":"OK"}`
- [ ] Login API returns JWT token
- [ ] Flutter app updated with new API URL

---

## 🎉 Default Login

After setup is complete:

- **Email**: `admin@faceml.com`
- **Password**: `Admin@123`

**⚠️ IMPORTANT**: Change this password immediately after first login!

---

## 🐛 Troubleshooting

### Can't connect to database
```bash
# Test database connection
mysql -u rootclockin_user -p -h localhost rootclockin_db
# Enter password: #1_Oc&FelV$B.c9I
```

### Port 3000 already in use
```bash
# Change PORT in .env file
PORT=3001
```

### npm install fails
```bash
# Clear cache and retry
npm cache clean --force
npm install
```

### Can't access from external
- Check firewall rules
- Check if port 3000 is open
- Consider using Nginx/Apache proxy
- Contact hosting support

---

## 📞 Support

If you encounter issues:

1. Check PM2 logs: `pm2 logs faceml-backend`
2. Check server logs: `tail -f /path/to/backend/*.log`
3. Verify .env file has correct values
4. Ensure all npm packages installed
5. Check Node.js version: `node --version` (should be 16+)

---

## 🔒 Security Reminder

- [ ] Change default admin password
- [ ] Keep .env file secure
- [ ] Regular database backups
- [ ] Use HTTPS in production
- [ ] Keep dependencies updated

---

Good luck! 🚀

