const DbHelper = require("../../helpers/DbHelper");
const AppError = require("../../utils/appError");
const conn = require("../../services/db");

async function getSubscriptionPlanById(req, res, next) {
  try {
    const { id } = req.params;

    if (!id) {
      return next(new AppError("Plan ID is required", 400));
    }

    // Convert id to integer
    const planIdInt = parseInt(id, 10);
    if (isNaN(planIdInt)) {
      return next(new AppError("Invalid plan ID format", 400));
    }

    const query =
      "SELECT id, name, price, duration_type, max_locations, max_staff, description, status FROM `subscription_plans` WHERE `is_deleted` IS NULL AND `status` = 'active' AND id = ?";

    const result = await DbHelper.promisifyQuery(query, conn, next, [planIdInt]);

    if (!result || result.length === 0) {
      console.log("Plan not found in getPlanById - Plan ID:", planIdInt);
      // Check if plan exists but is inactive
      const checkPlanQuery = `
        SELECT id, status, is_deleted 
        FROM subscription_plans 
        WHERE id = ?
      `;
      const checkPlan = await DbHelper.promisifyQuery(
        checkPlanQuery,
        conn,
        next,
        [planIdInt]
      );
      
      if (checkPlan && checkPlan.length > 0) {
        const plan = checkPlan[0];
        if (plan.status !== 'active') {
          return res.status(200).json({
            status: "error",
            message: `Subscription plan is ${plan.status}. Please select an active plan.`,
          });
        }
        if (plan.is_deleted) {
          return res.status(200).json({
            status: "error",
            message: "Subscription plan has been deleted",
          });
        }
      }
      
      return res.status(200).json({
        status: "error",
        message: "Subscription plan not found or inactive",
      });
    }

    res.status(200).json({
      status: "success",
      message: "Subscription plan fetched successfully",
      data: result[0],
    });
  } catch (e) {
    console.log("Exception Error : Get Subscription Plan By ID ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = getSubscriptionPlanById;

