const AppError = require("../../utils/appError");
const conn = require("../../services/db");
const DbHelper = require("../../helpers/DbHelper");

async function UserSettings(req, res, next) {
  if (!req?.body) return next(new AppError("No req data found", 404));
  try {
    const {
      account_notification,
    } = req?.body;
    const { user_id } = req?.headers;

    const userNotificationSetting = await DbHelper.promisifyQuery(
      `SELECT id FROM user_notification_settings WHERE user_id = ${user_id} `,
      conn,
      next
    );

    if (userNotificationSetting.length < 1) {
      conn.query(
        `INSERT INTO user_notification_settings (account_notification, new_contest, contest_result, new_participation, voting_notification, user_id) VALUES (?,0,0,0,0,?)`,
        [
          account_notification,
          user_id,
        ],
        async function (err, result, fields) {
          if (err) {
            console.log("error", err);
            const errorMessage =
              err?.message || "Something went wrong, Please try again";
            return next(new AppError(errorMessage, 500));
          }
          res.status(200).json({
            status: "success",
            message: "Your notification settings saved successfully.",
          });
        }
      );
    } else {
      const userNotificationSettingId = userNotificationSetting[0].id;
      conn.query(
        `UPDATE user_notification_settings SET account_notification = ?, new_contest = 0, contest_result = 0, new_participation = 0, voting_notification = 0 WHERE id = ?`,
        [
          account_notification,
          userNotificationSettingId,
        ],
        async function (err, result, fields) {
          if (err) {
            const errorMessage =
              err?.message || "Something went wrong, Please try again";
            return next(new AppError(errorMessage, 500));
          }
          res.status(200).json({
            status: "success",
            message: "Your notification settings updated successfully.",
          });
        }
      );
    }
  } catch (e) {
    console.log("Exception Error : User Info api failure details ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = UserSettings;
