-- Fix for JWT Token Refresh Error
-- Run this on your MySQL database

-- Use your database
USE project_management;

-- Create refresh_tokens table if it doesn't exist
CREATE TABLE IF NOT EXISTS refresh_tokens (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  token TEXT NOT NULL,
  expires_at DATETIME NOT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
  INDEX idx_user_id (user_id),
  INDEX idx_expires_at (expires_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Verify table was created
SHOW TABLES LIKE 'refresh_tokens';

-- Show table structure
DESCRIBE refresh_tokens;

-- Clean up any expired tokens (optional)
DELETE FROM refresh_tokens WHERE expires_at < NOW();

-- Show remaining tokens count
SELECT COUNT(*) as active_tokens FROM refresh_tokens WHERE expires_at > NOW();
