#!/bin/bash

# Quick Deployment Script for Server Error Fixes
# Run this on your server after uploading the modified files

echo "🚀 Starting deployment of server error fixes..."

# Navigate to project directory
cd /home/hrbackendtest/public_html || exit

echo "📦 Installing dependencies (if needed)..."
npm install

echo "🔍 Checking environment variables..."
if ! grep -q "JWT_REFRESH_SECRET" .env; then
    echo "⚠️  WARNING: JWT_REFRESH_SECRET not found in .env"
    echo "Please add the following to your .env file:"
    echo ""
    echo "JWT_REFRESH_SECRET=your_refresh_secret_key_here"
    echo "JWT_REFRESH_EXPIRES_IN=30d"
    echo ""
fi

echo "🔄 Restarting PM2 processes..."
pm2 restart all

echo "⏳ Waiting for services to start..."
sleep 5

echo "📊 Checking PM2 status..."
pm2 status

echo "📝 Showing recent logs..."
pm2 logs --lines 20 --nostream

echo ""
echo "✅ Deployment complete!"
echo ""
echo "Monitor logs with: pm2 logs"
echo "Check status with: pm2 status"
