-- MySQL dump 10.13  Distrib 9.5.0, for macos15.4 (arm64)
--
-- Host: localhost    Database: faceml_db
-- ------------------------------------------------------
-- Server version	9.5.0
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `attendance`
--

DROP TABLE IF EXISTS `attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `branch_id` int NOT NULL,
  `clock_in_time` timestamp NULL DEFAULT NULL,
  `clock_out_time` timestamp NULL DEFAULT NULL,
  `clock_in_location` varchar(255) DEFAULT NULL,
  `clock_out_location` varchar(255) DEFAULT NULL,
  `total_hours` decimal(5,2) DEFAULT NULL,
  `attendance_date` date NOT NULL,
  `status` enum('present','absent','half_day','on_leave') DEFAULT 'present',
  `notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_staff_id` (`staff_id`),
  KEY `idx_branch_id` (`branch_id`),
  KEY `idx_attendance_date` (`attendance_date`),
  KEY `idx_date_staff` (`attendance_date`,`staff_id`),
  CONSTRAINT `attendance_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `attendance_ibfk_2` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=577 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendance`
--

LOCK TABLES `attendance` WRITE;
/*!40000 ALTER TABLE `attendance` DISABLE KEYS */;
INSERT INTO `attendance` (`id`, `staff_id`, `branch_id`, `clock_in_time`, `clock_out_time`, `clock_in_location`, `clock_out_location`, `total_hours`, `attendance_date`, `status`, `notes`, `created_at`, `updated_at`) VALUES (426,34,3,'2025-10-30 03:30:00','2025-10-30 11:30:00',NULL,NULL,8.00,'2025-10-30','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(427,34,3,'2025-10-29 03:30:00','2025-10-29 11:30:00',NULL,NULL,8.00,'2025-10-29','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(428,34,3,'2025-10-28 03:30:00','2025-10-28 11:30:00',NULL,NULL,8.00,'2025-10-28','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(429,34,3,'2025-10-27 03:30:00','2025-10-27 11:30:00',NULL,NULL,8.00,'2025-10-27','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(430,34,3,'2025-10-24 03:30:00','2025-10-24 11:30:00',NULL,NULL,8.00,'2025-10-24','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(431,34,3,'2025-10-23 03:30:00','2025-10-23 11:30:00',NULL,NULL,8.00,'2025-10-23','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(432,34,3,'2025-10-22 03:30:00','2025-10-22 11:30:00',NULL,NULL,8.00,'2025-10-22','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(433,34,3,'2025-10-21 03:30:00','2025-10-21 11:30:00',NULL,NULL,8.00,'2025-10-21','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(434,34,3,'2025-10-20 03:30:00','2025-10-20 11:30:00',NULL,NULL,8.00,'2025-10-20','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(435,34,3,'2025-10-17 03:30:00','2025-10-17 11:30:00',NULL,NULL,8.00,'2025-10-17','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(436,34,3,'2025-10-16 03:30:00','2025-10-16 11:30:00',NULL,NULL,8.00,'2025-10-16','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(437,34,3,'2025-10-15 03:30:00','2025-10-15 11:30:00',NULL,NULL,8.00,'2025-10-15','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(438,34,3,'2025-10-14 03:30:00','2025-10-14 11:30:00',NULL,NULL,8.00,'2025-10-14','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(439,34,3,'2025-10-13 03:30:00','2025-10-13 11:30:00',NULL,NULL,8.00,'2025-10-13','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(440,34,3,'2025-10-10 03:30:00','2025-10-10 11:30:00',NULL,NULL,8.00,'2025-10-10','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(441,34,3,'2025-10-09 03:30:00','2025-10-09 11:30:00',NULL,NULL,8.00,'2025-10-09','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(442,34,3,'2025-10-08 03:30:00','2025-10-08 11:30:00',NULL,NULL,8.00,'2025-10-08','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(443,34,3,'2025-10-07 03:30:00','2025-10-07 11:30:00',NULL,NULL,8.00,'2025-10-07','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(444,34,3,'2025-10-06 03:30:00','2025-10-06 11:30:00',NULL,NULL,8.00,'2025-10-06','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(445,34,3,'2025-10-03 03:30:00','2025-10-03 11:30:00',NULL,NULL,8.00,'2025-10-03','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(446,34,3,'2025-10-02 03:30:00','2025-10-02 11:30:00',NULL,NULL,8.00,'2025-10-02','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(447,34,3,'2025-10-01 03:30:00','2025-10-01 11:30:00',NULL,NULL,8.00,'2025-10-01','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(448,34,3,'2025-09-30 03:30:00','2025-09-30 11:30:00',NULL,NULL,8.00,'2025-09-30','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(449,34,3,'2025-09-29 03:30:00','2025-09-29 11:30:00',NULL,NULL,8.00,'2025-09-29','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(450,34,3,'2025-09-26 03:30:00','2025-09-26 11:30:00',NULL,NULL,8.00,'2025-09-26','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(451,34,3,'2025-09-25 03:30:00','2025-09-25 11:30:00',NULL,NULL,8.00,'2025-09-25','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(452,34,3,'2025-09-24 03:30:00','2025-09-24 11:30:00',NULL,NULL,8.00,'2025-09-24','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(453,34,3,'2025-09-23 03:30:00','2025-09-23 11:30:00',NULL,NULL,8.00,'2025-09-23','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(454,34,3,'2025-09-22 03:30:00','2025-09-22 11:30:00',NULL,NULL,8.00,'2025-09-22','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(455,34,3,'2025-09-19 03:30:00','2025-09-19 11:30:00',NULL,NULL,8.00,'2025-09-19','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(456,34,3,'2025-09-18 03:30:00','2025-09-18 11:30:00',NULL,NULL,8.00,'2025-09-18','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(457,34,3,'2025-09-17 03:30:00','2025-09-17 11:30:00',NULL,NULL,8.00,'2025-09-17','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(458,34,3,'2025-09-16 03:30:00','2025-09-16 11:30:00',NULL,NULL,8.00,'2025-09-16','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(459,34,3,'2025-09-15 03:30:00','2025-09-15 11:30:00',NULL,NULL,8.00,'2025-09-15','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(460,34,3,'2025-09-12 03:30:00','2025-09-12 11:30:00',NULL,NULL,8.00,'2025-09-12','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(461,34,3,'2025-09-11 03:30:00','2025-09-11 11:30:00',NULL,NULL,8.00,'2025-09-11','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(462,34,3,'2025-09-10 03:30:00','2025-09-10 11:30:00',NULL,NULL,8.00,'2025-09-10','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(463,34,3,'2025-09-09 03:30:00','2025-09-09 11:30:00',NULL,NULL,8.00,'2025-09-09','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(464,34,3,'2025-09-08 03:30:00','2025-09-08 11:30:00',NULL,NULL,8.00,'2025-09-08','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(465,34,3,'2025-09-05 03:30:00','2025-09-05 11:30:00',NULL,NULL,8.00,'2025-09-05','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(466,34,3,'2025-09-04 03:30:00','2025-09-04 11:30:00',NULL,NULL,8.00,'2025-09-04','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(467,34,3,'2025-09-03 03:30:00','2025-09-03 11:30:00',NULL,NULL,8.00,'2025-09-03','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(468,34,3,'2025-09-02 03:30:00','2025-09-02 11:30:00',NULL,NULL,8.00,'2025-09-02','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(469,34,3,'2025-09-01 03:30:00','2025-09-01 11:30:00',NULL,NULL,8.00,'2025-09-01','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(470,34,3,'2025-08-29 03:30:00','2025-08-29 11:30:00',NULL,NULL,8.00,'2025-08-29','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(471,35,3,'2025-10-30 03:30:00','2025-10-30 11:30:00',NULL,NULL,8.00,'2025-10-30','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(472,35,3,'2025-10-29 02:30:00','2025-10-29 10:30:00',NULL,NULL,8.00,'2025-10-29','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(473,35,3,'2025-10-28 03:30:00','2025-10-28 09:30:00',NULL,NULL,6.00,'2025-10-28','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(474,35,3,'2025-10-27 03:30:00','2025-10-27 11:30:00',NULL,NULL,8.00,'2025-10-27','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(475,35,3,'2025-10-24 02:30:00','2025-10-24 10:30:00',NULL,NULL,8.00,'2025-10-24','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(476,35,3,'2025-10-23 03:30:00','2025-10-23 09:30:00',NULL,NULL,6.00,'2025-10-23','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(477,35,3,'2025-10-22 03:30:00','2025-10-22 11:30:00',NULL,NULL,8.00,'2025-10-22','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(478,35,3,'2025-10-21 02:30:00','2025-10-21 10:30:00',NULL,NULL,8.00,'2025-10-21','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(479,35,3,'2025-10-20 03:30:00','2025-10-20 09:30:00',NULL,NULL,6.00,'2025-10-20','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(480,35,3,'2025-10-17 03:30:00','2025-10-17 11:30:00',NULL,NULL,8.00,'2025-10-17','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(481,35,3,'2025-10-16 02:30:00','2025-10-16 10:30:00',NULL,NULL,8.00,'2025-10-16','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(482,35,3,'2025-10-15 03:30:00','2025-10-15 09:30:00',NULL,NULL,6.00,'2025-10-15','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(483,35,3,'2025-10-14 03:30:00','2025-10-14 11:30:00',NULL,NULL,8.00,'2025-10-14','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(484,35,3,'2025-10-13 02:30:00','2025-10-13 10:30:00',NULL,NULL,8.00,'2025-10-13','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(485,35,3,'2025-10-10 03:30:00','2025-10-10 09:30:00',NULL,NULL,6.00,'2025-10-10','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(486,35,3,'2025-10-09 03:30:00','2025-10-09 11:30:00',NULL,NULL,8.00,'2025-10-09','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(487,35,3,'2025-10-08 02:30:00','2025-10-08 10:30:00',NULL,NULL,8.00,'2025-10-08','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(488,35,3,'2025-10-07 03:30:00','2025-10-07 09:30:00',NULL,NULL,6.00,'2025-10-07','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(489,35,3,'2025-10-06 03:30:00','2025-10-06 11:30:00',NULL,NULL,8.00,'2025-10-06','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(490,35,3,'2025-10-03 02:30:00','2025-10-03 10:30:00',NULL,NULL,8.00,'2025-10-03','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(491,35,3,'2025-10-02 03:30:00','2025-10-02 09:30:00',NULL,NULL,6.00,'2025-10-02','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(492,35,3,'2025-10-01 03:30:00','2025-10-01 11:30:00',NULL,NULL,8.00,'2025-10-01','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(493,35,3,'2025-09-30 02:30:00','2025-09-30 10:30:00',NULL,NULL,8.00,'2025-09-30','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(494,35,3,'2025-09-29 03:30:00','2025-09-29 09:30:00',NULL,NULL,6.00,'2025-09-29','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(495,35,3,'2025-09-26 03:30:00','2025-09-26 11:30:00',NULL,NULL,8.00,'2025-09-26','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(496,35,3,'2025-09-25 02:30:00','2025-09-25 10:30:00',NULL,NULL,8.00,'2025-09-25','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(497,35,3,'2025-09-24 03:30:00','2025-09-24 09:30:00',NULL,NULL,6.00,'2025-09-24','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(498,35,3,'2025-09-23 03:30:00','2025-09-23 11:30:00',NULL,NULL,8.00,'2025-09-23','present','Shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(499,35,3,'2025-09-22 02:30:00','2025-09-22 10:30:00',NULL,NULL,8.00,'2025-09-22','present','Shift 8-4','2025-10-30 12:05:33','2025-10-30 12:05:33'),(500,35,3,'2025-09-19 03:30:00','2025-09-19 09:30:00',NULL,NULL,6.00,'2025-09-19','present','Shift 9-3','2025-10-30 12:05:33','2025-10-30 12:05:33'),(501,36,3,'2025-10-30 03:30:00','2025-10-30 11:30:00',NULL,NULL,8.00,'2025-10-30','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(502,36,3,'2025-10-29 03:30:00','2025-10-29 11:30:00',NULL,NULL,8.00,'2025-10-29','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(503,36,3,'2025-10-28 03:30:00','2025-10-28 11:30:00',NULL,NULL,8.00,'2025-10-28','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(504,36,3,'2025-10-27 03:30:00','2025-10-27 11:30:00',NULL,NULL,8.00,'2025-10-27','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(505,36,3,'2025-10-24 03:30:00','2025-10-24 11:30:00',NULL,NULL,8.00,'2025-10-24','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(506,36,3,'2025-10-22 03:30:00','2025-10-22 11:30:00',NULL,NULL,8.00,'2025-10-22','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(507,36,3,'2025-10-21 03:30:00','2025-10-21 11:30:00',NULL,NULL,8.00,'2025-10-21','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(508,36,3,'2025-10-17 03:30:00','2025-10-17 11:30:00',NULL,NULL,8.00,'2025-10-17','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(509,36,3,'2025-10-16 03:30:00','2025-10-16 11:30:00',NULL,NULL,8.00,'2025-10-16','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(510,36,3,'2025-10-15 03:30:00','2025-10-15 11:30:00',NULL,NULL,8.00,'2025-10-15','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(511,36,3,'2025-10-14 03:30:00','2025-10-14 11:30:00',NULL,NULL,8.00,'2025-10-14','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(512,36,3,'2025-10-13 03:30:00','2025-10-13 11:30:00',NULL,NULL,8.00,'2025-10-13','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(513,36,3,'2025-10-10 03:30:00','2025-10-10 11:30:00',NULL,NULL,8.00,'2025-10-10','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(514,36,3,'2025-10-09 03:30:00','2025-10-09 11:30:00',NULL,NULL,8.00,'2025-10-09','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(515,36,3,'2025-10-08 03:30:00','2025-10-08 11:30:00',NULL,NULL,8.00,'2025-10-08','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(516,36,3,'2025-10-07 03:30:00','2025-10-07 11:30:00',NULL,NULL,8.00,'2025-10-07','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(517,36,3,'2025-10-06 03:30:00','2025-10-06 11:30:00',NULL,NULL,8.00,'2025-10-06','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(518,36,3,'2025-10-03 03:30:00','2025-10-03 11:30:00',NULL,NULL,8.00,'2025-10-03','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(519,36,3,'2025-10-01 03:30:00','2025-10-01 11:30:00',NULL,NULL,8.00,'2025-10-01','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(520,36,3,'2025-09-30 03:30:00','2025-09-30 11:30:00',NULL,NULL,8.00,'2025-09-30','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(521,36,3,'2025-09-26 03:30:00','2025-09-26 11:30:00',NULL,NULL,8.00,'2025-09-26','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(522,36,3,'2025-09-25 03:30:00','2025-09-25 11:30:00',NULL,NULL,8.00,'2025-09-25','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(523,36,3,'2025-09-24 03:30:00','2025-09-24 11:30:00',NULL,NULL,8.00,'2025-09-24','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(524,36,3,'2025-09-23 03:30:00','2025-09-23 11:30:00',NULL,NULL,8.00,'2025-09-23','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(525,36,3,'2025-09-22 03:30:00','2025-09-22 11:30:00',NULL,NULL,8.00,'2025-09-22','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(526,36,3,'2025-09-19 03:30:00','2025-09-19 11:30:00',NULL,NULL,8.00,'2025-09-19','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(527,36,3,'2025-09-18 03:30:00','2025-09-18 11:30:00',NULL,NULL,8.00,'2025-09-18','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(528,36,3,'2025-09-17 03:30:00','2025-09-17 11:30:00',NULL,NULL,8.00,'2025-09-17','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(529,36,3,'2025-09-16 03:30:00','2025-09-16 11:30:00',NULL,NULL,8.00,'2025-09-16','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(530,36,3,'2025-09-15 03:30:00','2025-09-15 11:30:00',NULL,NULL,8.00,'2025-09-15','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(531,36,3,'2025-09-12 03:30:00','2025-09-12 11:30:00',NULL,NULL,8.00,'2025-09-12','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(532,36,3,'2025-09-10 03:30:00','2025-09-10 11:30:00',NULL,NULL,8.00,'2025-09-10','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(533,36,3,'2025-09-09 03:30:00','2025-09-09 11:30:00',NULL,NULL,8.00,'2025-09-09','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(534,36,3,'2025-09-05 03:30:00','2025-09-05 11:30:00',NULL,NULL,8.00,'2025-09-05','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(535,36,3,'2025-09-04 03:30:00','2025-09-04 11:30:00',NULL,NULL,8.00,'2025-09-04','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(536,36,3,'2025-09-03 03:30:00','2025-09-03 11:30:00',NULL,NULL,8.00,'2025-09-03','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(537,36,3,'2025-09-02 03:30:00','2025-09-02 11:30:00',NULL,NULL,8.00,'2025-09-02','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(538,36,3,'2025-09-01 03:30:00','2025-09-01 11:30:00',NULL,NULL,8.00,'2025-09-01','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(539,36,3,'2025-08-29 03:30:00','2025-08-29 11:30:00',NULL,NULL,8.00,'2025-08-29','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(540,36,3,'2025-08-28 03:30:00','2025-08-28 11:30:00',NULL,NULL,8.00,'2025-08-28','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(541,36,3,'2025-08-27 03:30:00','2025-08-27 11:30:00',NULL,NULL,8.00,'2025-08-27','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(542,36,3,'2025-08-26 03:30:00','2025-08-26 11:30:00',NULL,NULL,8.00,'2025-08-26','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(543,36,3,'2025-08-25 03:30:00','2025-08-25 11:30:00',NULL,NULL,8.00,'2025-08-25','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(544,36,3,'2025-08-22 03:30:00','2025-08-22 11:30:00',NULL,NULL,8.00,'2025-08-22','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(545,36,3,'2025-08-20 03:30:00','2025-08-20 11:30:00',NULL,NULL,8.00,'2025-08-20','present','Regular shift 9-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(546,37,3,'2025-10-30 04:30:00','2025-10-30 11:30:00',NULL,NULL,7.00,'2025-10-30','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(547,37,3,'2025-10-29 04:30:00','2025-10-29 11:30:00',NULL,NULL,7.00,'2025-10-29','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(548,37,3,'2025-10-28 04:30:00','2025-10-28 11:30:00',NULL,NULL,7.00,'2025-10-28','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(549,37,3,'2025-10-27 04:30:00','2025-10-27 11:30:00',NULL,NULL,7.00,'2025-10-27','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(550,37,3,'2025-10-24 04:30:00','2025-10-24 11:30:00',NULL,NULL,7.00,'2025-10-24','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(551,37,3,'2025-10-23 04:30:00','2025-10-23 11:30:00',NULL,NULL,7.00,'2025-10-23','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(552,37,3,'2025-10-22 04:30:00','2025-10-22 11:30:00',NULL,NULL,7.00,'2025-10-22','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(553,37,3,'2025-10-21 04:30:00','2025-10-21 11:30:00',NULL,NULL,7.00,'2025-10-21','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(554,37,3,'2025-10-20 04:30:00','2025-10-20 11:30:00',NULL,NULL,7.00,'2025-10-20','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(555,37,3,'2025-10-17 04:30:00','2025-10-17 11:30:00',NULL,NULL,7.00,'2025-10-17','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(556,37,3,'2025-10-16 04:30:00','2025-10-16 11:30:00',NULL,NULL,7.00,'2025-10-16','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(557,37,3,'2025-10-15 04:30:00','2025-10-15 11:30:00',NULL,NULL,7.00,'2025-10-15','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(558,37,3,'2025-10-14 04:30:00','2025-10-14 11:30:00',NULL,NULL,7.00,'2025-10-14','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(559,37,3,'2025-10-13 04:30:00','2025-10-13 11:30:00',NULL,NULL,7.00,'2025-10-13','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(560,37,3,'2025-10-10 04:30:00','2025-10-10 11:30:00',NULL,NULL,7.00,'2025-10-10','present','Regular shift 10-5','2025-10-30 12:05:33','2025-10-30 12:05:33'),(567,46,3,'2025-11-03 10:40:57','2025-11-03 10:41:13','Face Recognition','Face Recognition',-0.50,'2025-11-03','present',NULL,'2025-11-03 10:40:57','2025-11-19 12:11:54'),(571,46,3,'2025-11-19 05:09:14','2025-11-19 13:09:00','Manual Edit','Manual Edit',7.73,'2025-11-19','present',NULL,'2025-11-19 04:45:12','2025-11-19 12:19:41'),(572,46,3,'2025-11-19 05:09:14',NULL,'Face Recognition',NULL,NULL,'2025-11-19','present',NULL,'2025-11-19 05:09:14','2025-11-19 05:09:14'),(573,46,3,'2025-11-24 05:58:15','2025-11-24 06:01:18','Face Recognition','Face Recognition',0.05,'2025-11-24','present',NULL,'2025-11-24 05:58:15','2025-11-24 06:01:18'),(574,46,3,'2025-11-26 10:38:58','2025-11-26 10:40:41','Face Recognition','Face Recognition',0.03,'2025-11-26','present',NULL,'2025-11-26 10:38:58','2025-11-26 10:40:41'),(575,46,3,'2025-11-26 10:42:38','2025-11-26 10:42:41','Face Recognition','Face Recognition',0.00,'2025-11-26','present',NULL,'2025-11-26 10:42:38','2025-11-26 10:42:41'),(576,46,3,'2025-11-26 10:42:58',NULL,'Face Recognition',NULL,NULL,'2025-11-26','present',NULL,'2025-11-26 10:42:58','2025-11-26 10:42:58');
/*!40000 ALTER TABLE `attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `branches`
--

DROP TABLE IF EXISTS `branches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `branches` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shop_id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `address` text,
  `contact_phone` varchar(20) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `pin` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_shop_id` (`shop_id`),
  CONSTRAINT `branches_ibfk_1` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `branches`
--

LOCK TABLES `branches` WRITE;
/*!40000 ALTER TABLE `branches` DISABLE KEYS */;
INSERT INTO `branches` (`id`, `shop_id`, `name`, `address`, `contact_phone`, `is_active`, `created_at`, `updated_at`, `pin`) VALUES (3,3,'Main Branch',NULL,NULL,1,'2025-10-30 10:26:18','2025-10-30 10:26:18',NULL),(4,4,'Main Branch',NULL,NULL,1,'2025-11-21 04:37:57','2025-11-21 04:37:57',NULL),(5,5,'Main Branch',NULL,NULL,1,'2025-11-21 04:38:16','2025-11-21 04:38:16',NULL),(6,3,'Branch 2','secound brach',NULL,1,'2025-11-21 04:55:15','2025-11-21 04:55:15','1234');
/*!40000 ALTER TABLE `branches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `feature_flags`
--

DROP TABLE IF EXISTS `feature_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `feature_flags` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shop_id` int DEFAULT NULL,
  `feature_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_shop_feature` (`shop_id`,`feature_name`),
  CONSTRAINT `fk_feature_flags_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `feature_flags`
--

LOCK TABLES `feature_flags` WRITE;
/*!40000 ALTER TABLE `feature_flags` DISABLE KEYS */;
INSERT INTO `feature_flags` (`id`, `shop_id`, `feature_name`, `is_enabled`, `created_at`, `updated_at`) VALUES (1,NULL,'roster',1,'2025-11-19 04:10:47','2025-11-21 04:38:16'),(2,NULL,'availability',1,'2025-11-19 04:10:47','2025-11-21 04:41:23'),(3,5,'roster',0,'2025-11-21 04:38:16','2025-11-21 04:38:16'),(4,3,'roster',0,'2025-11-21 04:40:53','2025-11-26 03:57:40'),(5,3,'availability',0,'2025-11-21 04:40:54','2025-11-26 03:57:34'),(6,1,'roster',0,'2025-11-21 04:43:07','2025-11-21 04:43:07'),(7,5,'availability',0,'2025-11-26 03:57:38','2025-11-26 03:57:38'),(8,4,'availability',0,'2025-11-26 03:57:40','2025-11-26 03:57:40'),(9,4,'roster',0,'2025-11-26 03:57:40','2025-11-26 03:57:40'),(10,2,'availability',0,'2025-11-26 03:57:45','2025-11-26 03:57:45'),(11,2,'roster',0,'2025-11-26 03:57:46','2025-11-26 03:57:46'),(12,1,'availability',0,'2025-11-26 03:57:49','2025-11-26 03:57:49');
/*!40000 ALTER TABLE `feature_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roster_assignments`
--

DROP TABLE IF EXISTS `roster_assignments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roster_assignments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `branch_id` int NOT NULL,
  `shift_date` date NOT NULL,
  `staff_id` int NOT NULL,
  `shift_type_id` char(36) NOT NULL,
  `position_id` char(36) DEFAULT NULL,
  `start_minutes` int NOT NULL,
  `end_minutes` int NOT NULL,
  `break_type_ids` json DEFAULT NULL,
  `notes` text,
  `created_by_type` enum('shop_admin','staff') DEFAULT 'shop_admin',
  `created_by_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `position_id` (`position_id`),
  KEY `idx_branch_date` (`branch_id`,`shift_date`),
  KEY `idx_staff_date` (`staff_id`,`shift_date`),
  KEY `idx_shift_type_date` (`shift_type_id`,`shift_date`),
  CONSTRAINT `roster_assignments_ibfk_1` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  CONSTRAINT `roster_assignments_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `roster_assignments_ibfk_3` FOREIGN KEY (`shift_type_id`) REFERENCES `roster_shift_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `roster_assignments_ibfk_4` FOREIGN KEY (`position_id`) REFERENCES `roster_positions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roster_assignments`
--

LOCK TABLES `roster_assignments` WRITE;
/*!40000 ALTER TABLE `roster_assignments` DISABLE KEYS */;
INSERT INTO `roster_assignments` (`id`, `branch_id`, `shift_date`, `staff_id`, `shift_type_id`, `position_id`, `start_minutes`, `end_minutes`, `break_type_ids`, `notes`, `created_by_type`, `created_by_id`, `created_at`, `updated_at`) VALUES (9,3,'2025-11-19',47,'12cf293b-3ce7-4232-88d0-ff8d2c6cd1dc',NULL,540,660,'[\"f53af7cd-36e6-449c-9178-1a80dd83b570\"]',NULL,'shop_admin',5,'2025-11-16 12:40:58','2025-11-16 12:40:58');
/*!40000 ALTER TABLE `roster_assignments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roster_break_types`
--

DROP TABLE IF EXISTS `roster_break_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roster_break_types` (
  `id` char(36) NOT NULL,
  `branch_id` int NOT NULL,
  `name` varchar(120) NOT NULL,
  `duration_minutes` int NOT NULL,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_branch` (`branch_id`),
  CONSTRAINT `roster_break_types_ibfk_1` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roster_break_types`
--

LOCK TABLES `roster_break_types` WRITE;
/*!40000 ALTER TABLE `roster_break_types` DISABLE KEYS */;
INSERT INTO `roster_break_types` (`id`, `branch_id`, `name`, `duration_minutes`, `created_by`, `created_at`, `updated_at`) VALUES ('f53af7cd-36e6-449c-9178-1a80dd83b570',3,'tea',15,5,'2025-11-16 12:39:50','2025-11-16 12:39:50');
/*!40000 ALTER TABLE `roster_break_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roster_positions`
--

DROP TABLE IF EXISTS `roster_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roster_positions` (
  `id` char(36) NOT NULL,
  `branch_id` int NOT NULL,
  `name` varchar(120) NOT NULL,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_branch` (`branch_id`),
  CONSTRAINT `roster_positions_ibfk_1` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roster_positions`
--

LOCK TABLES `roster_positions` WRITE;
/*!40000 ALTER TABLE `roster_positions` DISABLE KEYS */;
INSERT INTO `roster_positions` (`id`, `branch_id`, `name`, `created_by`, `created_at`, `updated_at`) VALUES ('016f6dad-b7dc-4f08-b6ae-8e6e6690b5bf',3,'stff',5,'2025-11-16 12:39:37','2025-11-16 12:39:37');
/*!40000 ALTER TABLE `roster_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roster_shift_types`
--

DROP TABLE IF EXISTS `roster_shift_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roster_shift_types` (
  `id` char(36) NOT NULL,
  `branch_id` int NOT NULL,
  `name` varchar(120) NOT NULL,
  `start_minutes` int NOT NULL,
  `end_minutes` int NOT NULL,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_branch` (`branch_id`),
  CONSTRAINT `roster_shift_types_ibfk_1` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roster_shift_types`
--

LOCK TABLES `roster_shift_types` WRITE;
/*!40000 ALTER TABLE `roster_shift_types` DISABLE KEYS */;
INSERT INTO `roster_shift_types` (`id`, `branch_id`, `name`, `start_minutes`, `end_minutes`, `created_by`, `created_at`, `updated_at`) VALUES ('12cf293b-3ce7-4232-88d0-ff8d2c6cd1dc',3,'ñí]<þ',540,660,5,'2025-11-16 12:39:24','2025-11-16 12:39:24'),('fe14d4e2-d081-40ec-bbef-c337b9d1cf7a',3,'mor',540,660,5,'2025-11-16 12:39:19','2025-11-16 12:39:19');
/*!40000 ALTER TABLE `roster_shift_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shops`
--

DROP TABLE IF EXISTS `shops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shops` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `admin_id` int NOT NULL,
  `address` text,
  `contact_phone` varchar(20) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_admin_id` (`admin_id`),
  CONSTRAINT `shops_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shops`
--

LOCK TABLES `shops` WRITE;
/*!40000 ALTER TABLE `shops` DISABLE KEYS */;
INSERT INTO `shops` (`id`, `name`, `admin_id`, `address`, `contact_phone`, `is_active`, `created_at`, `updated_at`) VALUES (1,'áb©',3,'áß',NULL,1,'2025-10-23 12:01:26','2025-10-23 12:01:26'),(2,'shop2\'s Shop',4,NULL,NULL,1,'2025-10-23 12:07:04','2025-10-23 12:07:04'),(3,'sahil',5,NULL,NULL,1,'2025-10-30 10:26:18','2025-10-30 10:26:18'),(4,'Test Shop 1763699877027',7,NULL,NULL,1,'2025-11-21 04:37:57','2025-11-21 04:37:57'),(5,'Test Shop 1763699896570',8,NULL,NULL,1,'2025-11-21 04:38:16','2025-11-21 04:38:16');
/*!40000 ALTER TABLE `shops` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `staff`
--

DROP TABLE IF EXISTS `staff`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `staff` (
  `id` int NOT NULL AUTO_INCREMENT,
  `branch_id` int NOT NULL,
  `staff_code` varchar(50) NOT NULL,
  `full_name` text COMMENT 'Encrypted',
  `email` text COMMENT 'Encrypted',
  `phone` text COMMENT 'Encrypted',
  `position` varchar(100) DEFAULT NULL,
  `hourly_rate` decimal(8,2) DEFAULT NULL,
  `face_embeddings` longtext COMMENT 'Encrypted string (was JSON)',
  `profile_image_path` text,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `staff_code` (`staff_code`),
  KEY `idx_branch_id` (`branch_id`),
  KEY `idx_staff_code` (`staff_code`),
  CONSTRAINT `staff_ibfk_1` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `staff`
--

LOCK TABLES `staff` WRITE;
/*!40000 ALTER TABLE `staff` DISABLE KEYS */;
INSERT INTO `staff` (`id`, `branch_id`, `staff_code`, `full_name`, `email`, `phone`, `position`, `hourly_rate`, `face_embeddings`, `profile_image_path`, `is_active`, `created_at`, `updated_at`) VALUES (34,3,'STF002','dc960508895c5956bcc90d64f7d10f6b:87d1cb5e95b9a9dac4edff24f988df9e64:495dc2df094370db6ab4f834d59c2ecc','6006d3607a14c25e76583161a02d963b:1e1a167082b60ce25ad8dbdf:9eee7fc01942d8011965c35c87f72112','58f4657e1120b04b63e9ae49f26c0a1b:e53be5dee18ef38c98b1:8e26e440890a687a2b47269ce6c38d8f','Staff $15/hr',15.00,NULL,NULL,1,'2025-10-30 12:05:33','2025-11-24 05:19:07'),(35,3,'STF003','91f86dfad3b946340584b20bafc97d43:cd2a734405900455c01287aae4a7ade77dcc317cd76f854b:ab7e99789798279d80e1fa57b45e2a69','c22d114325e9aa2fff63a0323d514f00:97867013fdd424beaa115747793fd06b:85e4e356febce4d05098351148aa3858','6832b5518e61f8bd83baeecf924d824f:07eaa642917a33da2a77:48c662a014ded8e25c9fb2c6005f72c8','Staff $15/hr',15.00,NULL,NULL,1,'2025-10-30 12:05:33','2025-11-24 05:19:07'),(36,3,'STF004','ee419c1047637f767555e056ccd9b743:cc07b85238b71ffd9dd265d1d91ce39afa1033:b6f77e686cdc2c008fe4d4d7f1076700','6e41aad671f218f71684247c0c3b4237:2ac6322e99468453ae90ad8579ff:5ad105f8e0072027080ff352e62ce42d','fe05f8dd1cff81eff247880d26f482b6:b4f3baa2974cf37aff70:0038e1b291718f0a708e2af1c4a75a2c','Staff $15/hr',15.00,NULL,NULL,1,'2025-10-30 12:05:33','2025-11-24 05:19:07'),(37,3,'STF005','0727b62f7b69be4ec064476d2d625521:cdf29d14327dbafd7015bf7981b3fa5f2569:67e7a11f01c915f22be9fc7f9e85ec48','0cd01ce400b85694ee1566c53df89ed3:28a0c0cef226ceb9f2636fe2:576e40a1ca88a9c0230187480443aa1f','eca6c8bbb60d13481ac2efe150c93d3b:53797dc2eb0a487abbba:41e994ed902d7e808b1231671416175d','Staff $10/hr',10.00,NULL,NULL,1,'2025-10-30 12:05:33','2025-11-24 05:19:07'),(46,3,'B3-433989','63e4836570040fb6c758a1476b64df70:b42232123f:7aabc32c7efe65515ff0400b4522ef72',NULL,'b3f12efa65b51d3d063145f500830924:10260b66fc9dc5a44fa34028:fccae1971f2a42869036881d013ef903','staff',25.00,'81d10ced6f22f97736378b8523b65a44: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:7e9f66511f75e6485e537eceba5f76f3',NULL,1,'2025-11-03 10:40:51','2025-11-26 10:41:41'),(47,3,'B3-546467','38c9a630abb121555379960bd5461238:4a35f20c9c:23538b0f96d288080cbf01dc2cac64a3',NULL,'a8b67169eddb7de4adf64b8f51dc6330:fa1d454ee0b978ddc04d:e73f62ddffad702bcc5c60f77ad2849f','Frff',10.00,'184d899bd3c22b60fac67fdc016beec1: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:09ff89292c88544b94ced850a2367d7e',NULL,1,'2025-11-16 12:36:16','2025-11-26 10:41:41'),(48,3,'B3-614259','6574068fb8c215cb76ea797673a37bea:4d4d2ce0:96f3ce43a88fae4f9991f571a1523071',NULL,'2ab821ef44d9ece8390c99b3758f73f2:29b49d92bd091d82c7dd59:ca8ee960a2700263fa0a863ba4d6fc0e','staff',11.00,NULL,NULL,1,'2025-11-25 13:17:18','2025-11-25 13:17:18');
/*!40000 ALTER TABLE `staff` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `staff_availability`
--

DROP TABLE IF EXISTS `staff_availability`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `staff_availability` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `branch_id` int NOT NULL,
  `availability_date` date NOT NULL,
  `is_available` tinyint(1) DEFAULT '1',
  `start_minutes` int DEFAULT NULL,
  `end_minutes` int DEFAULT NULL,
  `notes` text,
  `submitted_by` enum('staff','shop_admin') DEFAULT 'staff',
  `submitted_by_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_staff_availability` (`staff_id`,`availability_date`),
  KEY `idx_branch_date` (`branch_id`,`availability_date`),
  KEY `idx_staff_date` (`staff_id`,`availability_date`),
  CONSTRAINT `staff_availability_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `staff_availability_ibfk_2` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `staff_availability`
--

LOCK TABLES `staff_availability` WRITE;
/*!40000 ALTER TABLE `staff_availability` DISABLE KEYS */;
INSERT INTO `staff_availability` (`id`, `staff_id`, `branch_id`, `availability_date`, `is_available`, `start_minutes`, `end_minutes`, `notes`, `submitted_by`, `submitted_by_id`, `created_at`, `updated_at`) VALUES (1,47,3,'2025-11-17',1,540,1080,NULL,'staff',47,'2025-11-16 12:37:30','2025-11-16 12:37:30'),(2,47,3,'2025-11-18',1,540,1080,NULL,'staff',47,'2025-11-16 12:37:30','2025-11-16 12:37:30'),(3,47,3,'2025-11-19',0,NULL,NULL,NULL,'staff',47,'2025-11-16 12:37:30','2025-11-16 12:37:30'),(4,47,3,'2025-11-20',1,540,1080,NULL,'staff',47,'2025-11-16 12:37:30','2025-11-16 12:37:30'),(5,47,3,'2025-11-21',1,540,1080,NULL,'staff',47,'2025-11-16 12:37:30','2025-11-16 12:37:30'),(6,47,3,'2025-11-22',0,NULL,NULL,NULL,'staff',47,'2025-11-16 12:37:30','2025-11-16 12:37:30'),(7,47,3,'2025-11-23',0,NULL,NULL,NULL,'staff',47,'2025-11-16 12:37:30','2025-11-16 12:37:30');
/*!40000 ALTER TABLE `staff_availability` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `role` enum('superadmin','shop_admin') NOT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `idx_email` (`email`),
  KEY `idx_role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `email`, `password`, `full_name`, `role`, `is_active`, `created_at`, `updated_at`) VALUES (1,'admin@faceml.com','$2a$10$gMx4gnr4IByZvX1YdPXUR.X4PYYCTe3Rx0Cu6kWdHrMy08UMt9346','Super Admin','superadmin',1,'2025-10-23 11:48:23','2025-11-14 10:53:24'),(3,'shop1@gmail.com','$2a$10$a.ALYME7ibZxFyR7gu.RVORqi.RFzIw8fk5481.Wxj8eg0tc7n08G','sun','shop_admin',1,'2025-10-23 12:01:26','2025-10-23 12:01:26'),(4,'shop2@gmail.com','$2a$10$wtAf4giHMCmfRMi8CJZNyOUg2UQbmu23VNRFQLcMMykm4S/0TIzxO','shop2','shop_admin',1,'2025-10-23 12:07:04','2025-10-23 12:07:04'),(5,'shop@gmail.com','$2a$10$ubOXlCavStGBSu2/wpXwFuCF5jF/y8UOaTyB4DfXSC/5B0QUMJxKm','sahil','shop_admin',1,'2025-10-30 10:26:18','2025-10-30 10:26:18'),(7,'test_shop_1763699877027@example.com','$2a$10$nZ7Ij1y6/CwMflaOy/pGQuyovueAKjVrrLNKAmrOWe32CuHVf45gC','Test Shop Owner','shop_admin',1,'2025-11-21 04:37:57','2025-11-21 04:37:57'),(8,'test_shop_1763699896570@example.com','$2a$10$5t2JSxdU7R6xt/nl7C6Z5e/GG5xYUtjoeQyRzguFX.AUbb9MN0UMq','Test Shop Owner','shop_admin',1,'2025-11-21 04:38:16','2025-11-21 04:38:16');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `work_sessions`
--

DROP TABLE IF EXISTS `work_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_sessions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `attendance_id` int NOT NULL,
  `staff_id` int NOT NULL,
  `start_time` timestamp NOT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `duration_minutes` int DEFAULT NULL,
  `session_type` enum('work','break','overtime') DEFAULT 'work',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_attendance_id` (`attendance_id`),
  KEY `idx_staff_id` (`staff_id`),
  CONSTRAINT `work_sessions_ibfk_1` FOREIGN KEY (`attendance_id`) REFERENCES `attendance` (`id`) ON DELETE CASCADE,
  CONSTRAINT `work_sessions_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `work_sessions`
--

LOCK TABLES `work_sessions` WRITE;
/*!40000 ALTER TABLE `work_sessions` DISABLE KEYS */;
INSERT INTO `work_sessions` (`id`, `attendance_id`, `staff_id`, `start_time`, `end_time`, `duration_minutes`, `session_type`, `created_at`) VALUES (1,571,46,'2025-11-19 04:45:31','2025-11-19 04:46:12',1,'break','2025-11-19 04:45:31'),(4,571,46,'2025-11-19 04:45:00','2025-11-19 05:00:00',15,'break','2025-11-19 05:11:15'),(5,567,46,'2025-11-03 10:40:00','2025-11-03 10:55:00',15,'break','2025-11-19 12:11:41'),(6,567,46,'2025-11-03 11:40:00','2025-11-03 11:55:00',15,'break','2025-11-19 12:11:54'),(7,572,46,'2025-11-19 05:09:00',NULL,NULL,'break','2025-11-19 12:18:26');
/*!40000 ALTER TABLE `work_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'faceml_db'
--

--
-- Dumping routines for database 'faceml_db'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-11-28 14:41:02
