const util = require("util");
const AppError = require("../utils/appError");

module.exports = {
    promisifyQuery: async (sqlQuery, conn, next, params = null) => {
        const query = util.promisify(conn.query).bind(conn);
        try {
            if (params && Array.isArray(params) && params.length > 0) {
                return await query(sqlQuery, params);
            }
            return await query(sqlQuery);
        } catch (err) {
            console.log("Exception ", err);
            return next(new AppError(err, 500));
        }
    },
};



