// Middleware to set user_id in headers for compatibility with subscription controllers
// This extracts user_id from req.user (set by authenticateToken) and adds it to headers
const setUserId = (req, res, next) => {
  if (req.user && req.user.id) {
    req.headers.user_id = req.user.id.toString();
  }
  next();
};

module.exports = setUserId;



