const express = require('express');
const router = express.Router();
const attendanceController = require('../controllers/attendanceController');
const { authenticateToken, authorizeRoles } = require('../middleware/auth');

router.use(authenticateToken);

router.post(
  '/clock-in',
  authorizeRoles('shop_admin', 'staff'),
  attendanceController.clockIn,
);
router.post(
  '/clock-out',
  authorizeRoles('shop_admin', 'staff'),
  attendanceController.clockOut,
);
router.post(
  '/break-clock-in',
  authorizeRoles('shop_admin', 'staff'),
  attendanceController.breakClockIn,
);
router.post(
  '/break-clock-out',
  authorizeRoles('shop_admin', 'staff'),
  attendanceController.breakClockOut,
);

router.post(
  '/manual',
  authorizeRoles('shop_admin'),
  attendanceController.markManualAttendance,
);
router.post(
  '/manual-attendance',
  authorizeRoles('shop_admin'),
  attendanceController.createOrUpdateManualAttendance,
);
router.get(
  '/branch/:branch_id',
  authorizeRoles('shop_admin'),
  attendanceController.getAttendance,
);
router.get(
  '/branch/:branch_id/reports',
  authorizeRoles('shop_admin'),
  attendanceController.getBranchReports,
);
router.get(
  '/staff/:staff_id',
  authorizeRoles('shop_admin'),
  attendanceController.getStaffAttendance,
);
router.get(
  '/branch/:branch_id/summary',
  authorizeRoles('shop_admin'),
  attendanceController.getAttendanceSummary,
);
router.get(
  '/breaks/:attendance_id',
  authorizeRoles('shop_admin'),
  attendanceController.getBreaks,
);
router.post(
  '/breaks',
  authorizeRoles('shop_admin'),
  attendanceController.addBreak,
);
router.put(
  '/breaks/:break_id',
  authorizeRoles('shop_admin'),
  attendanceController.updateBreak,
);
router.delete(
  '/breaks/:break_id',
  authorizeRoles('shop_admin'),
  attendanceController.deleteBreak,
);

module.exports = router;

