const express = require('express');
const router = express.Router();
const availabilityController = require('../controllers/availabilityController');
const { authenticateToken, authorizeRoles } = require('../middleware/auth');

router.use(authenticateToken);

router.get(
  '/staff/:staff_id',
  authorizeRoles('shop_admin', 'staff'),
  availabilityController.getStaffAvailability,
);

router.post(
  '/staff/:staff_id',
  authorizeRoles('shop_admin', 'staff'),
  availabilityController.upsertStaffAvailability,
);

router.get(
  '/branch/:branch_id',
  authorizeRoles('shop_admin'),
  availabilityController.getBranchAvailability,
);

module.exports = router;


