const express = require('express');
const router = express.Router();
const branchController = require('../controllers/branchController');
const { authenticateToken, authorizeRoles } = require('../middleware/auth');

// All routes require authentication and shop_admin role
router.use(authenticateToken);
router.use(authorizeRoles('shop_admin'));

router.post('/', branchController.createBranch);
router.get('/shop/:shop_id', branchController.getBranchesByShop);
router.get('/:id', branchController.getBranchById);
router.put('/:id', branchController.updateBranch);
router.delete('/:id', branchController.deleteBranch);
router.post('/:id/verify-pin', branchController.verifyBranchPin);

module.exports = router;

