const express = require('express');
const router = express.Router();
const featureFlagsController = require('../controllers/featureFlagsController');
const { authenticateToken } = require('../middleware/auth');

// Public route - check if a feature is enabled (no auth required)
router.get('/check/:featureName', featureFlagsController.checkFeatureFlag);

// Protected routes - only superadmin can access
router.get('/', authenticateToken, featureFlagsController.getFeatureFlags);
router.get('/:featureName', authenticateToken, featureFlagsController.getFeatureFlag);
router.put('/:featureName', authenticateToken, featureFlagsController.updateFeatureFlag);

module.exports = router;

