const express = require('express');
const router = express.Router();
const rosterController = require('../controllers/rosterController');
const { authenticateToken, authorizeRoles } = require('../middleware/auth');

router.use(authenticateToken);

router.get(
  '/branch/:branch_id/config',
  authorizeRoles('shop_admin'),
  rosterController.getConfig,
);

router.post(
  '/branch/:branch_id/shift-types',
  authorizeRoles('shop_admin'),
  rosterController.createShiftType,
);

router.put(
  '/shift-types/:id',
  authorizeRoles('shop_admin'),
  rosterController.updateShiftType,
);

router.delete(
  '/shift-types/:id',
  authorizeRoles('shop_admin'),
  rosterController.deleteShiftType,
);

router.post(
  '/branch/:branch_id/positions',
  authorizeRoles('shop_admin'),
  rosterController.createPosition,
);

router.delete(
  '/positions/:id',
  authorizeRoles('shop_admin'),
  rosterController.deletePosition,
);

router.post(
  '/branch/:branch_id/break-types',
  authorizeRoles('shop_admin'),
  rosterController.createBreakType,
);

router.put(
  '/break-types/:id',
  authorizeRoles('shop_admin'),
  rosterController.updateBreakType,
);

router.delete(
  '/break-types/:id',
  authorizeRoles('shop_admin'),
  rosterController.deleteBreakType,
);

router.get(
  '/branch/:branch_id/assignments',
  authorizeRoles('shop_admin'),
  rosterController.getAssignments,
);

router.post(
  '/branch/:branch_id/assignments',
  authorizeRoles('shop_admin'),
  rosterController.upsertAssignments,
);

module.exports = router;

