const express = require('express');
const router = express.Router();
const shopAdminController = require('../controllers/shopAdminController');
const { authenticateToken, authorizeRoles } = require('../middleware/auth');

// All routes require authentication and superadmin role
router.use(authenticateToken);
router.use(authorizeRoles('superadmin'));

router.post('/', shopAdminController.createShopAdmin);
router.get('/', shopAdminController.getAllShopAdmins);
router.put('/:id', shopAdminController.updateShopAdmin);
router.delete('/:id', shopAdminController.deleteShopAdmin);

module.exports = router;

