const express = require('express');
const router = express.Router();
const staffController = require('../controllers/staffController');
const { authenticateToken, authorizeRoles } = require('../middleware/auth');

// All routes require authentication and shop_admin role
router.use(authenticateToken);
router.use(authorizeRoles('shop_admin'));

router.post('/', staffController.createStaff);
router.get('/branch/:branch_id', staffController.getStaffByBranch);
router.get('/:id', staffController.getStaffById);
router.put('/:id', staffController.updateStaff);
router.delete('/:id', staffController.deleteStaff);
router.put('/:id/face-embeddings', staffController.updateFaceEmbeddings);

module.exports = router;

