const express = require('express');
const router = express.Router();
const subscriptionController = require('../controllers/subscription');
const { authenticateToken } = require('../middleware/auth');
const setUserId = require('../middleware/setUserId');

// Guest routes (no auth required)
router.get('/subscription-plans', subscriptionController.getActivePlans);
router.get('/subscription-plans/:id', subscriptionController.getPlanById);
router.post('/stripe-webhook', subscriptionController.stripeWebhook);

// Protected routes (auth required)
router.post('/create-subscription-payment', authenticateToken, setUserId, subscriptionController.createPaymentIntent);
router.post('/create-subscription', authenticateToken, setUserId, subscriptionController.createSubscription);
router.get('/check-active-subscription', authenticateToken, setUserId, subscriptionController.checkActiveSubscription);
router.post('/cancel-subscription', authenticateToken, setUserId, subscriptionController.cancelSubscription);
router.post('/reactivate-subscription', authenticateToken, setUserId, subscriptionController.reactivateSubscription);
router.post('/change-subscription-plan', authenticateToken, setUserId, subscriptionController.changePlan);
router.get('/subscription-history', authenticateToken, setUserId, subscriptionController.getSubscriptionHistory);

module.exports = router;

