const express = require('express');
const router = express.Router();
const userController = require('../controllers/user');
const logsController = require('../controllers/logs');
const { authenticateToken } = require('../middleware/auth');
const setUserId = require('../middleware/setUserId');

// User info routes
router.get('/user-info', authenticateToken, setUserId, userController.userInfo);
router.post('/save-user-settings', authenticateToken, setUserId, userController.userSettings);

// Logs routes
router.get('/logs', authenticateToken, setUserId, logsController.walletLogs);
router.get('/order-logs', authenticateToken, setUserId, logsController.purchaseLogs);
router.get('/reward-logs', authenticateToken, setUserId, logsController.rewardLogs);

module.exports = router;



