const mysql = require('mysql2/promise');
require('dotenv').config();

async function addStaffColumns() {
  let connection;
  
  try {
    console.log('🔄 Connecting to MySQL database...');
    
    connection = await mysql.createConnection({
      host: process.env.DB_HOST || 'localhost',
      user: process.env.DB_USER || 'root',
      password: process.env.DB_PASSWORD || '',
      database: process.env.DB_NAME || 'faceml_db',
      port: process.env.DB_PORT || 3306
    });

    console.log('✓ Connected to database');

    // Check if columns already exist
    console.log('🔄 Checking existing columns...');
    const [columns] = await connection.query(`
      SHOW COLUMNS FROM staff
    `);
    
    const existingColumns = columns.map(col => col.Field);
    console.log('Existing columns:', existingColumns.join(', '));

    // Add profile_image_path if it doesn't exist
    if (!existingColumns.includes('profile_image_path')) {
      console.log('🔄 Adding profile_image_path column...');
      await connection.query(`
        ALTER TABLE staff 
        ADD COLUMN profile_image_path TEXT NULL 
        AFTER face_embeddings
      `);
      console.log('✓ Added profile_image_path column');
    } else {
      console.log('✓ profile_image_path column already exists');
    }

    // Add hourly_rate if it doesn't exist
    if (!existingColumns.includes('hourly_rate')) {
      console.log('🔄 Adding hourly_rate column...');
      await connection.query(`
        ALTER TABLE staff 
        ADD COLUMN hourly_rate DECIMAL(10,2) DEFAULT 0.00 
        AFTER position
      `);
      console.log('✓ Added hourly_rate column');
    } else {
      console.log('✓ hourly_rate column already exists');
    }

    console.log('\n✅ Staff table migration completed successfully!\n');

  } catch (error) {
    console.error('❌ Migration failed:', error.message);
    console.error(error);
    process.exit(1);
  } finally {
    if (connection) {
      await connection.end();
    }
  }
}

addStaffColumns();

