require('dotenv').config();
const mysql = require('mysql2/promise');

async function addPinColumn() {
  console.log('Connecting to database...');
  const connection = await mysql.createConnection({
    host: process.env.DB_HOST,
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    port: process.env.DB_PORT || 3306
  });

  try {
    console.log('Adding pin column to branches table...');
    await connection.query(`
      ALTER TABLE branches
      ADD COLUMN pin VARCHAR(4) DEFAULT NULL;
    `);
    console.log('Successfully added pin column to branches table');
  } catch (error) {
    if (error.code === 'ER_DUP_FIELDNAME') {
      console.log('pin column already exists');
    } else {
      console.error('Error adding pin column:', error);
    }
  } finally {
    await connection.end();
  }
}

addPinColumn();
