-- Add shop_id column to feature_flags table
ALTER TABLE feature_flags ADD COLUMN shop_id INT NULL AFTER id;

-- Add foreign key constraint
ALTER TABLE feature_flags ADD CONSTRAINT fk_feature_flags_shop FOREIGN KEY (shop_id) REFERENCES shops(id) ON DELETE CASCADE;

-- Drop existing unique index on feature_name
DROP INDEX feature_name ON feature_flags;

-- Add index for faster lookups by shop and feature
CREATE INDEX idx_shop_feature ON feature_flags (shop_id, feature_name);
