-- ============================================
-- Feature Flags Table
-- Description: Stores feature enable/disable settings for super admin
-- ============================================
CREATE TABLE IF NOT EXISTS `feature_flags` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `feature_name` VARCHAR(100) NOT NULL,
  `is_enabled` BOOLEAN DEFAULT true,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `feature_name` (`feature_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default feature flags (enabled by default)
INSERT INTO `feature_flags` (`feature_name`, `is_enabled`) VALUES
('roster', true),
('availability', true)
ON DUPLICATE KEY UPDATE `feature_name` = `feature_name`;

