const mysql = require('mysql2/promise');
const path = require('path');
require('dotenv').config({ path: path.join(__dirname, '..', '.env') });

async function verifyEncryption() {
  let connection;
  try {
    connection = await mysql.createConnection({
      host: process.env.DB_HOST || 'localhost',
      user: process.env.DB_USER || 'root',
      password: process.env.DB_PASSWORD || '',
      database: process.env.DB_NAME || 'faceml_db',
      port: process.env.DB_PORT || 3306,
    });

    const [rows] = await connection.query('SELECT id, full_name, email, phone FROM staff LIMIT 3');
    console.log('--- Verification: Encrypted Data in DB ---');
    rows.forEach(row => {
      console.log(`ID: ${row.id}`);
      console.log(`Name: ${row.full_name.substring(0, 50)}...`); // Show start of encrypted string
      console.log(`Email: ${row.email ? row.email.substring(0, 50) + '...' : 'null'}`);
      console.log('---');
    });

  } catch (error) {
    console.error('Verification failed:', error);
  } finally {
    if (connection) await connection.end();
  }
}

verifyEncryption();
