// Database service compatibility layer for subscription controllers
// This provides a callback-based interface that subscription files expect
// while using the existing mysql2/promise pool underneath

const db = require('../config/database');
const mysql = require('mysql2');

// Create a connection-like object that works with callback-based queries
// but uses the promise-based pool
const connection = {
  query: function(sql, params, callback) {
    if (typeof params === 'function') {
      // No params provided, callback is second argument
      callback = params;
      params = [];
    }
    
    db.query(sql, params || [])
      .then(([rows, fields]) => {
        callback(null, rows, fields);
      })
      .catch((err) => {
        callback(err, null, null);
      });
  }
};

module.exports = connection;



