// Test script for encryption service
require('dotenv').config();

// Temporarily set encryption key for testing
process.env.ENCRYPTION_KEY = '31ee095f535fd22d3b58379f6f6c75e372729f1777bb12165eee5502ee75653c';

const encryptionService = require('./services/encryptionService');

console.log('🔄 Testing Encryption Service...\n');

// Test 1: Basic string encryption/decryption
console.log('Test 1: Basic String Encryption');
const testString = 'John Doe';
const encrypted = encryptionService.encrypt(testString);
const decrypted = encryptionService.decrypt(encrypted);
console.log(`  Original: ${testString}`);
console.log(`  Encrypted: ${encrypted}`);
console.log(`  Decrypted: ${decrypted}`);
console.log(`  ✓ Test 1: ${testString === decrypted ? 'PASSED' : 'FAILED'}\n`);

// Test 2: Email encryption
console.log('Test 2: Email Encryption');
const testEmail = 'john.doe@example.com';
const encryptedEmail = encryptionService.encrypt(testEmail);
const decryptedEmail = encryptionService.decrypt(encryptedEmail);
console.log(`  Original: ${testEmail}`);
console.log(`  Encrypted: ${encryptedEmail}`);
console.log(`  Decrypted: ${decryptedEmail}`);
console.log(`  ✓ Test 2: ${testEmail === decryptedEmail ? 'PASSED' : 'FAILED'}\n`);

// Test 3: Phone encryption
console.log('Test 3: Phone Encryption');
const testPhone = '+1234567890';
const encryptedPhone = encryptionService.encrypt(testPhone);
const decryptedPhone = encryptionService.decrypt(encryptedPhone);
console.log(`  Original: ${testPhone}`);
console.log(`  Encrypted: ${encryptedPhone}`);
console.log(`  Decrypted: ${decryptedPhone}`);
console.log(`  ✓ Test 3: ${testPhone === decryptedPhone ? 'PASSED' : 'FAILED'}\n`);

// Test 4: Face embeddings (JSON object)
console.log('Test 4: Face Embeddings Encryption');
const testEmbedding = { image: 'base64encodedimagedata...' };
const encryptedEmbedding = encryptionService.encryptFaceEmbeddings(testEmbedding);
const decryptedEmbedding = encryptionService.decryptFaceEmbeddings(encryptedEmbedding);
console.log(`  Original: ${JSON.stringify(testEmbedding)}`);
console.log(`  Encrypted: ${encryptedEmbedding}`);
console.log(`  Decrypted: ${JSON.stringify(decryptedEmbedding)}`);
console.log(`  ✓ Test 4: ${JSON.stringify(testEmbedding) === JSON.stringify(decryptedEmbedding) ? 'PASSED' : 'FAILED'}\n`);

// Test 5: Null handling
console.log('Test 5: Null Handling');
const encryptedNull = encryptionService.encrypt(null);
const decryptedNull = encryptionService.decrypt(null);
console.log(`  Encrypted null: ${encryptedNull}`);
console.log(`  Decrypted null: ${decryptedNull}`);
console.log(`  ✓ Test 5: ${encryptedNull === null && decryptedNull === null ? 'PASSED' : 'FAILED'}\n`);

// Test 6: Multiple encryptions produce different ciphertexts (due to random IV)
console.log('Test 6: Random IV Test');
const encrypted1 = encryptionService.encrypt(testString);
const encrypted2 = encryptionService.encrypt(testString);
console.log(`  Same plaintext, different ciphertexts: ${encrypted1 !== encrypted2 ? 'YES' : 'NO'}`);
console.log(`  Both decrypt correctly: ${encryptionService.decrypt(encrypted1) === testString && encryptionService.decrypt(encrypted2) === testString ? 'YES' : 'NO'}`);
console.log(`  ✓ Test 6: ${encrypted1 !== encrypted2 ? 'PASSED' : 'FAILED'}\n`);

console.log('✅ All encryption tests completed!');
