const mysql = require('mysql2/promise');
const encryptionService = require('./services/encryptionService');
require('dotenv').config();

async function verifyDecryption() {
  console.log('🔄 Verifying decryption from backend root...');
  console.log(`🔑 Key present: ${process.env.ENCRYPTION_KEY ? 'YES' : 'NO'}`);
  if (process.env.ENCRYPTION_KEY) {
    console.log(`🔑 Key length: ${process.env.ENCRYPTION_KEY.length}`);
    console.log(`🔑 Key start: ${process.env.ENCRYPTION_KEY.substring(0, 4)}...`);
  }

  let connection;
  try {
    connection = await mysql.createConnection({
      host: process.env.DB_HOST || 'localhost',
      user: process.env.DB_USER || 'root',
      password: process.env.DB_PASSWORD || '',
      database: process.env.DB_NAME || 'faceml_db',
      port: process.env.DB_PORT || 3306,
    });

    const [rows] = await connection.query('SELECT id, full_name FROM staff LIMIT 1');
    
    if (rows.length === 0) {
      console.log('❌ No staff records found');
      return;
    }

    const staff = rows[0];
    console.log(`\n📄 Testing Staff ID: ${staff.id}`);
    console.log(`🔒 Encrypted Name: ${staff.full_name.substring(0, 50)}...`);

    try {
      const decryptedName = encryptionService.decrypt(staff.full_name);
      console.log(`🔓 Decrypted Name: ${decryptedName}`);
      console.log('✅ Decryption SUCCESSFUL');
    } catch (error) {
      console.error('❌ Decryption FAILED:', error.message);
    }

  } catch (error) {
    console.error('❌ Error:', error);
  } finally {
    if (connection) await connection.end();
  }
}

verifyDecryption();
